/********************************************************************
		PopTEST (c) Copyright 1989 by MSI
		     Author - Ratko V. Tomic
*********************************************************************/

#include "cr.h"
#include "sio.h"

#ifdef PDK1
#include "lm.h"
#endif

#include "spawn.h"

/** RESIDENT CODE HOT-KEY LIST **/

#define SZX (80)
#define SZY (25)

#define EXE_K1 (0x57)			/* F11 */
#define EXE_K2 (M_LA|0x33)		/* Alt-Comma */
#define CMD_K1 (0x58)			/* F12 */
#define CMD_K2 (M_LA|0x34)		/* Alt-Period */
#define UNL_KEY (M_LC|M_LS|0x16)	/* Ctl-Shift-U */

#ifdef PDK1
word far *scr_buf;
#else
word *scr_buf;
#endif

/** TEST FUNCTION FOR POP-UP **/

#define LEN 64
#define MIN_P (0x0FFF)	/* 4K paragraphs = 64K of RAM minimum  */
#define MAX_P (0x2FFF)	/* 12K paragraphs= 192K of RAM maximum */

int img_hndl;			/* File handle used for swapping */
word lim_seg;			/* Valid only if LIM used */
dword lfpos;			/* File or LIM posit for graphics */
word MinP=MIN_P,MaxP=MAX_P;	/* MaxP may be adjusted if LIM too small */
char *shell_ptr;		/* COMMAND.COM name/path */
char shell_ln[]="  \r";		/* 2 spaces & Return */
char prog[LEN+2];
char cmd_ln[LEN+4]="  \r";	/* Strings for spawn() */
word mem_sz;			/* Size allocated in paragraphs */
char *tmp_buf;			/* Buffer with at least 128 char */
word free_MCB;			/* Used for spawn() workspace */
word cmd_env;			/* Environment to be passed to spawn() */
char run_it;			/* Set to NZ if no questions asked */

pop_func(ask)
{  register char *s;
   int k,ep;
   char *pn,*cn;

     crs_x=crs_y=0;
     if (!ask)		/* Just shell out */
	{
	pn=shell_ptr;
	cn=shell_ln;
	dsp("Enter EXIT when done.");
	goto RunProg;
	}

     s=pn=prog;
     cn=cmd_ln;
     if (run_it) goto RunProg;

     s[ep=LEN]=0;
     dsp("Program (w/.ext): ");		/* Get program name to run */
     k=edit_str(s,ep,&ep,pckey);
     if (k==K_ESC) return(0);

#ifdef PDK1     
     exp_fname(s,tmp_buf);
     tmp_buf[LEN]=0; str_cp(tmp_buf,s);
#endif
     crs_y++; crs_x=0;
     dsp("Command line: ");		/* Get command line */
     s=cmd_ln;*s++=0x20;*s++=0x20;	/* It must have 2 Blanks in front !*/
     s[ep=LEN+1]=0;
     k=str_pos(0xd,s); if (k) s[k-1]=0;	/* Remove <CR> from last run */
     k=edit_str(s,ep,&ep,pckey);
     if (k==K_ESC) return(0);
     s+=str_len(s); *(word*)s=0xd;	/* Put <CR> NULL at the end */

/** EXECUTE PROGRAM (DOS access already obtained in do_pop() **/

RunProg:
     crs_y++; crs_x=0; mv_crs();
     set_crs_type(crs_type0);
     if (!lim_seg) upd_file_size(img_hndl);
     k=spawn(pn,cn,cmd_env,free_MCB);	/* Run the program */
     if (pn==shell_ptr) flush_kbd();
     else
      {
      if (k<0)
	 {
	 dsp("Cannot run: ");
	 dsp(pn);
	 crs_y++; crs_x=0;
	 dsp("Press any key...");
	 mv_crs();
	 }
      if (run_it>=0) wait_key();
      }
     return(k);
}


/** SMALL UTILITY FUNCTIONS */

play()
{
   sound(880,20);
}

wait_key()
{
   play();
   flush_kbd();_hkey_again=0;
   while (!(anykey()|_hkey_again));
   flush_kbd();
}

xchg_scr()
{
   crs_x=crs_y=0;
#ifdef PDK1   
   swap_fblk(SZX,SZY,scr_buf);
#else
   swap_blk(SZX,SZY,scr_buf);
#endif
}


/************************************************
     INTERRUPT SERVICE ROUTINE FOR HOT-KEYS
*************************************************/


isr(hk)
{ void far *tp; /* Temporary far pointer */
  word fg_psp;  
     sound_off();
     if (dos_busy(20)) {play(); return;}  /* We need DOS */

     fg_psp=set_my_psp();

     mem_sz=get_app_mem(tmp_buf,img_hndl,lim_seg,MaxP,MaxP); /* Get memory */
     if (!mem_sz) goto MemErr;		/* Exit if can't get memory */

     tp=get_app_ptr();			/* Far pointer for workspace */
     if (0xffff==save_gs(img_hndl,lim_seg,1,lfpos,tp))
	goto VidErr;
     chk_video();			/* Get current video parameters */
#ifdef PDK1
     scr_buf=tp;			/*Save screen in freed far memory */
     free_MCB=split_mcb(app_MCB,((SZX*SZY*2)+15)/16);
     ffil_wrd(scr_buf,0x720,SZX*SZY);	/* Clear new screen */
#else
     free_MCB=app_MCB;
     fil_wrd(scr_buf,0x720,SZX*SZY);	/* Clear new screen */
#endif
     save_hcrs();			/* Save hardware cursor */
     xchg_scr();			/* Swap screen */
	pop_func(hk&1);			/* Ask then run the program */
     xchg_scr();
     restore_hcrs();
     restore_gs(img_hndl,lim_seg,1,lfpos,tp);
VidErr:
     ret_app_mem(tmp_buf,img_hndl,_dummy_ret);	/* Restore memory state */
MemErr:
     restore_psp(fg_psp);

}


